<?php
/**
 * Debug Logger
 * Reserve button debug için log yazma modülü
 */

// Direct access engelle
if (!defined('_WEBMALL')) {
    define('_WEBMALL', true);
}

// Error log dosyası
$logFile = __DIR__ . '/logs/reserve_debug.log';

// POST kontrolü
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Method Not Allowed');
}

// Action kontrolü
$action = $_POST['action'] ?? '';
if ($action !== 'log') {
    http_response_code(400);
    exit('Invalid action');
}

// Log mesajını al
$message = $_POST['message'] ?? '';
$timestamp = $_POST['timestamp'] ?? date('c');

if (empty($message)) {
    http_response_code(400);
    exit('No message');
}

// IP ve User Agent bilgisi
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';

// Log satırını oluştur
$logLine = sprintf(
    "[%s] [%s] %s (UA: %s)\n",
    date('Y-m-d H:i:s'),
    $ip,
    $message,
    substr($userAgent, 0, 100)
);

// Log dosyasına yaz
$result = file_put_contents($logFile, $logLine, FILE_APPEND | LOCK_EX);

if ($result === false) {
    http_response_code(500);
    exit('Failed to write log');
}

// Başarılı
http_response_code(200);
echo 'OK';
exit;
