// Reserve Button Fix - Production Version
// Cookie ve trim() sorunları düzeltildi - Custom modal ile güzel görünüm

(function() {
	// Sayfa yüklendiğinde modal'ı kapat (eski browser uyumlu)
	if (window.addEventListener) {
		window.addEventListener('load', function() {
			var modal = document.getElementById('alert_modal');
			if (modal) modal.style.display = 'none';
		});
	} else if (window.attachEvent) {
		window.attachEvent('onload', function() {
			var modal = document.getElementById('alert_modal');
			if (modal) modal.style.display = 'none';
		});
	}
	
	// Custom modal göster
	function showModal(title, message, callback) {
		var modal = document.getElementById('alert_modal');
		var alertTitle = document.getElementById('alert_title');
		var alertContent = document.getElementById('alert_content');
		var alertOk = document.getElementById('alert_ok');
		var alertClose = document.getElementById('alert_close');
		
		if (modal && alertTitle && alertContent) {
			alertTitle.innerHTML = title;
			alertContent.innerHTML = message;
			modal.style.display = 'block';
			
			if (callback) {
				alertOk.style.display = 'inline-block';
				alertOk.onclick = function() {
					modal.style.display = 'none';
					callback();
				};
				alertClose.textContent = 'Cancel';
			} else {
				alertOk.style.display = 'none';
				alertClose.textContent = 'OK';
			}
			
			alertClose.onclick = function() {
				modal.style.display = 'none';
			};
		} else {
			// Fallback to alert
			alert(message);
			if (callback) callback();
		}
	}
	
	// Orijinal addReserved fonksiyonunu override et
	window.addReserved = function(package_id) {
		// Cookie'leri oku, yoksa default değerler kullan
		var dir = getCookie('dir') || '/';
		var ext = getCookie('ext') || '.asp';
		var lang = getCookie('mlanguage1') || 'tr';
		
		var ajaxUrl = dir + "itemBuyGame_addReserved" + ext;
		
		// Mesajlar
		var messages = {
			'us': {
				title: 'Reserve',
				msg: 'Added to Reserved.<br><br>Do you want to check?',
				msg1: 'Selected item is already on Reserved',
				msg2: 'You can keep maximum 20 items in Reserved.<br><br>Please remove some items to add more.',
				msg3: 'Your level is insufficient to reserve this item.<br><br>Please check the item restrictions.'
			},
			'tr': {
				title: 'Rezerve',
				msg: 'Rezerve listesine eklendi.<br><br>Kontrol etmek ister misiniz?',
				msg1: 'Seçilen ürün zaten rezervde',
				msg2: 'Rezervde maksimum 20 ürün tutabilirsiniz.<br><br>Daha fazla ürün eklemek için bazı ürünleri silin.',
				msg3: 'Mevcut seviyeniz bu ürünü almak için yetersiz.<br><br>Lütfen ürün kısıtlamalarını kontrol edin.'
			}
		};
		
		var msgs = messages[lang] || messages['us'];
		
		$.ajax({
			type: "POST",
			url: ajaxUrl,
			data: "cart=" + package_id,
			success: function(res) {
				// trim() yerine replace (eski browser uyumlu)
				res = (res + '').replace(/^\s+|\s+$/g, '');
				
				if (res == '0') {
					showModal(msgs.title, msgs.msg, function() {
						window.location.href = dir + 'itemBuyGame_Reserved' + ext + '?st3=3';
					});
				}
				else if (res == '-1') {
					showModal(msgs.title, msgs.msg1);
				}
				else if (res == '-2') {
					showModal(msgs.title, msgs.msg2);
				}
				else if (res == '-3') {
					showModal(msgs.title, msgs.msg3);
				}
				else {
					showModal('Error', 'Unknown response: ' + res);
				}
			},
			error: function(xhr, status, error) {
				showModal('Error', 'Connection error. Please try again.');
			}
		});
	};
	
	// Cookie helper
	function getCookie(name) {
		var value = "; " + document.cookie;
		var parts = value.split("; " + name + "=");
		if (parts.length == 2) return parts.pop().split(";").shift();
		return null;
	}
})();
