<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ----- Kendi config'in -----
$_config['mssql'] = [
  "ip"        => "51.38.19.195,1433",
  "id"        => "sa",
  "pw"        => "VictoXProject*",
  "db"        => "SRO_VT_ACCOUNT",
  "portal_db" => "GB_JoymaxPortal"
];
// ----------------------------

function out($label, $val = null) {
  if ($val === null) { echo "<h3>".$label."</h3>"; return; }
  if (is_array($val) || is_object($val)) { $val = print_r($val, true); }
  echo "<pre><b>{$label}:</b> {$val}</pre>";
}

out("PHP Version", PHP_VERSION);
out("Loaded extensions", get_loaded_extensions());

$hasPdoSqlsrv = extension_loaded('pdo_sqlsrv');
$hasSqlsrv    = extension_loaded('sqlsrv');
out("pdo_sqlsrv loaded?", $hasPdoSqlsrv ? "YES" : "NO");
out("sqlsrv loaded?",     $hasSqlsrv    ? "YES" : "NO");

$server = $_config['mssql']['ip'];
$user   = $_config['mssql']['id'];
$pass   = $_config['mssql']['pw'];
$db     = $_config['mssql']['db'];
$db2    = $_config['mssql']['portal_db'];

// ODBC18 default Encrypt=Yes. Self-signed ise TrustServerCertificate=Yes gerekebilir.
$common_conn_opts = [
  "Encrypt" => "Yes",
  "TrustServerCertificate" => "Yes",
  "LoginTimeout" => 5,
  "ApplicationIntent" => "ReadWrite"
];

try {
  if ($hasPdoSqlsrv) {
    out("=== PDO_SQLSRV TEST ===");
    $dsn = "sqlsrv:Server={$server};Database={$db};Encrypt={$common_conn_opts['Encrypt']};TrustServerCertificate={$common_conn_opts['TrustServerCertificate']}";
    $pdo = new PDO($dsn, $user, $pass, [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::SQLSRV_ATTR_DIRECT_QUERY => true,
    ]);

    $ver = $pdo->query("SELECT @@VERSION AS v")->fetch(PDO::FETCH_ASSOC);
    out("@@VERSION", $ver['v']);

    $dbn = $pdo->query("SELECT DB_NAME() AS dbname")->fetch(PDO::FETCH_ASSOC);
    out("Current DB", $dbn['dbname']);

    // Örnek hızlı sorgu
    $stmt = $pdo->query("SELECT TOP (1) name, database_id FROM sys.databases ORDER BY database_id");
    out("sys.databases sample row", $stmt->fetch(PDO::FETCH_ASSOC));

    // İkinci DB’ye geçip test
    $pdo->exec("USE [{$db2}]");
    $dbn2 = $pdo->query("SELECT DB_NAME() AS dbname")->fetch(PDO::FETCH_ASSOC);
    out("Switched to", $dbn2['dbname']);

    // Basit sayım (tablo yoksa hata verebilir; önemli değil – bağlantıyı görmüş olduk)
    try {
      $cnt = $pdo->query("SELECT COUNT(*) AS c FROM INFORMATION_SCHEMA.TABLES")->fetch(PDO::FETCH_ASSOC);
      out("INFORMATION_SCHEMA.TABLES count", $cnt['c']);
    } catch (Exception $e) {
      out("Query warning", $e->getMessage());
    }
    out("PDO test", "OK ✅");
  } elseif ($hasSqlsrv) {
    out("=== SQLSRV (procedural) TEST ===");
    $connInfo = array_merge($common_conn_opts, [
      "UID" => $user,
      "PWD" => $pass,
      "Database" => $db,
    ]);
    $conn = sqlsrv_connect($server, $connInfo);
    if (!$conn) { throw new Exception(print_r(sqlsrv_errors(), true)); }

    $res = sqlsrv_query($conn, "SELECT @@VERSION AS v; SELECT DB_NAME() AS dbname;");
    do {
      while ($row = sqlsrv_fetch_array($res, SQLSRV_FETCH_ASSOC)) {
        out("Row", $row);
      }
    } while (sqlsrv_next_result($res));

    sqlsrv_query($conn, "USE [{$db2}]");
    $res2 = sqlsrv_query($conn, "SELECT DB_NAME() AS dbname");
    out("Switched to", sqlsrv_fetch_array($res2, SQLSRV_FETCH_ASSOC));

    out("SQLSRV test", "OK ✅");
  } else {
    out("ERROR", "Ne pdo_sqlsrv ne de sqlsrv yüklü. Önce PHP extension’ları kur.");
  }
} catch (Throwable $e) {
  out("EXCEPTION", $e->getMessage());
  if (function_exists('sqlsrv_errors') && ($errs = sqlsrv_errors())) {
    out("sqlsrv_errors()", $errs);
  }
}

echo "<hr><small>Güvenlik notu: Bu dosyayı test bittikten sonra sil.</small>";
